-- mods/germanium/init.lua
-- ===================
-- See LICENSE.txt for licensing and README.md for other information.

-- load support for intllib
local modpath = minetest.get_modpath(minetest.get_current_modname())
local S = minetest.get_translator("germanium")

-- Lapis Lazuli Ore
minetest.register_node("germanium:stone_with_germanium", {
	description = S("germanium Ore"),
	tiles = {"default_stone.png^germanium_mineral_germanium.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'germanium:germanium 2'},  --The first and second drops ever
			},
			{
				items = {'germanium:germanium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'germanium:germanium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'germanium:germanium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

-- Lapis Item
minetest.register_craftitem("germanium:germanium", {
	description = S("germanium"),
	inventory_image = "germanium.png",
})

-- Lapis Block
minetest.register_node("germanium:germaniumblock", {
	description = S("germanium Block"),
	tiles = {"germanium_germaniumblock.png"},
	is_ground_content = true,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_stone_defaults(),
})

-- Lapis Block Crafting
minetest.register_craft({
	output = 'germanium:germanium',
	recipe = {
		{'germanium:germanium', 'germanium:germanium', 'germanium:germanium'},
		{'germanium:germanium', 'germanium:germanium', 'germanium:germanium'},
		{'germanium:germanium', 'germanium:germanium', 'germanium:germanium'},
	}
})

-- Lapis Items from Lapis Block Crafting
minetest.register_craft({
	output = 'germanium:germanium 9',
	recipe = {
		{'germanium:germanium'},
	}
})

-- Ore generation
-- -128 <-> -255
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "germanium:stone_with_germanium",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 31000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "germanium:stone_with_germanium",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = 31000,
})


